<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;
    public $timestamps = FALSE;

    protected $table = "transactions";
    protected $fillable = ["ref", "description", "payment_supplier", "payment_delivery", "shipping_company_id", "category", "provider_id", "buy_price", "sell_price", "quantity", "sup_fees","created_at"];
    
    protected $casts = [
        'created_at' => 'datetime:Y-m-d',
        'updated_at' => 'datetime:Y-m-d',
    ];





    public function shippingcompany()
    {
        return $this->belongsTo(ShippingCompany::class, 'shipping_company_id');
    }

    public function provider()
    {
        return $this->belongsTo(Provider::class, 'provider_id');
    }

   
}
