<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DataTables\ShippingCompaniesDataTable;
use App\Models\ShippingCompany;

class ShippingCompanyController extends Controller
{
     public function index(ShippingCompaniesDataTable $dataTable) {
        return $dataTable->render('admin.shippingcompanies.index', ['title' => 'Contrôle des entreprises de livraison']);
    }

     public function create() {
   
        return view('admin.shippingcompanies.create', ['title' => 'Ajoute entreprise de livraison']);
    }

        public function store() {
        $data = $this->validate(request(),
            [   'name'           => 'required',
                'address'        => 'required',
                'tax'        => 'required|numeric|between:0,10',
                'phone_number_1' => 'required|numeric|digits_between:9,10',
                'phone_number_2' => 'nullable|numeric|digits_between:9,10'
            ], [], [
                'name'           => 'name',
                'address'        => 'address',
                'tax'           => 'tax',
                'phone_number_1' => 'phone_number_1',
                'phone_number_2' => 'phone_number_2',
            ]);
        ShippingCompany::create($data);
        session()->flash('success', 'Enregistrement Ajoute');
        return redirect(aurl('shippingcompanies'));
    }

       public function edit($id) {
        $shippingCompany = ShippingCompany::find($id);
        $title = 'entreprise de livraison edit ';

        return view('admin.shippingcompanies.edit', compact('shippingCompany', 'title'));
    }

        public function update(Request $r, $id) {

         $data = $this->validate(request(),
            [   'name'           => 'required',
                'address'        => 'required',
                'tax'        => 'required|numeric',
                'phone_number_1' => 'required|numeric|digits_between:9,10',
                'phone_number_2' => 'nullable|numeric|digits_between:9,10'
            ], [], [
                'name'           => 'name',
                'address'        => 'address',
                'tax'           => 'tax',
                'phone_number_1' => 'phone_number_1',
                'phone_number_2' => 'phone_number_2',
            ]);
     
        ShippingCompany::where('id', $id)->update($data);
        session()->flash('success', trans('Enregistrement supprimé'));
        return redirect(aurl('shippingcompanies'));
    }

      public function destroy($id) {
        ShippingCompany::find($id)->delete();
        session()->flash('success', 'Enregistrement mis à jour');
        return redirect(aurl('shippingcompanies'));
    }
}
