<?php

namespace App\DataTables;

use App\Models\Provider;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;

class ProvidersDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
         return datatables($query)
            ->addColumn('edit', 'admin.providers.btn.edit')
            ->addColumn('delete', 'admin.providers.btn.delete')
            ->rawColumns([
                'edit',
                'delete',
            ]);
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\Provider $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Provider $model)
    {
        return $model->newQuery();
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
          public function html() {
        return $this->builder()
                    ->columns($this->getColumns())
                    ->minifiedAjax()
                    ->parameters([
                'dom'        => 'Blfrtip',
                'lengthMenu' => [[10, 25, 50, 100], [10, 25, 50, 'All Record']],
                'buttons'    => [
                    [
                        'text' => '<i class="fa fa-plus"></i> '.'Ajoute Fournisseur', 'className' => 'btn btn-primary', "action" => "function(){

                            window.location.href = 'providers/create';
                        }"],

                    ['extend' => 'print', 'className' => 'btn btn-warning', 'text' => '<i class="fa fa-print"></i>'],
                    ['extend' => 'csv', 'className' => 'btn btn-info', 'text' => '<i class="fa fa-file"></i> '.'CSV'],
                    ['extend' => 'excel', 'className' => 'btn btn-success', 'text' => '<i class="fa fa-file"></i> '.'Excel'],
                    ['extend' => 'reload', 'className' => 'btn btn-default', 'text' => '<i class="fa fa-refresh"></i>'],
                  

                ],
                'initComplete' => " function () {
                    this.api().columns([2,3,4,5]).every(function () {
                        var column = this;
                        var input = document.createElement(\"input\");
                        $(input).appendTo($(column.footer()).empty())
                        .on('keyup', function () {
                            column.search($(this).val(), false, false, true).draw();
                        });
                    });
                }",


            ]);
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
           return [
           [
                'name'  => 'name',
                'data'  => 'name',
                'title' => 'nom',
            ], [
                'name'  => 'address',
                'data'  => 'address',
                'title' => 'adresse',
            ], [
                'name'  => 'domain',
                'data'  => 'domain',
                'title' => 'domaine',
            ], [
                'name'  => 'phone_number_1',
                'data'  => 'phone_number_1',
                'title' => 'numéro de tél 1',
            ],[
                'name'  => 'phone_number_2',
                'data'  => 'phone_number_2',
                'title' => 'numéro de tél 2',
            ], [
                'name'  => 'created_at',
                'data'  => 'created_at',
                'title' => 'created_at',
            ],[
                'name'       => 'edit',
                'data'       => 'edit',
                'title'      => 'edit',
                'exportable' => false,
                'printable'  => false,
                'orderable'  => false,
                'searchable' => false,
            ], [
                'name'       => 'delete',
                'data'       => 'delete',
                'title'      => 'delete',
                'exportable' => false,
                'printable'  => false,
                'orderable'  => false,
                'searchable' => false,
            ],

        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'Providers_' . date('YmdHis');
    }
}
