<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\DataTables\StockDataTable;
use App\Models\Stock;
use App\Models\Provider;

class StockController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(StockDataTable $dataTable) {
        return $dataTable->render('admin.stock.index', ['title' => 'Contrôle du stock']);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        // $products = \DB::connection('mysql2')->table('wp_posts')->where('post_type', 'product')->where('post_status', 'publish')->select('post_title')->get();
        // $productsNames = $products->pluck("post_title");
        
        $fournisseurs = Provider::all();
        $fournisseursSelect = [];
        foreach ($fournisseurs  as $fournisseur) {
            $fournisseursSelect[$fournisseur->id] =
                $fournisseur->name;
        }


        return view('admin.stock.create', ['title' => 'Ajoute Stock'],compact(
            'fournisseursSelect',
            //   'productsNames'
        )  );
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store() {
        $data = $this->validate(request(),
            [
                'description'     => 'required',
                'provider_id' => 'required',
                'price'    => 'required|numeric',
                'quantity' => 'required|numeric',
                'payment_state' => 'required'
            ], [], [
                'description' => 'description',
                'provider_id' => 'provider_id',
                'price'    => 'price',
                'quantity' => 'quantity',
                'payment_state' => 'payment_state'
            ]);
        Stock::create($data);
        session()->flash('success', 'Enregistrement ajouté');
        return redirect(aurl('stock'));
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
        $stock = Stock::find($id);
        $title = 'Stock Edit';

        // $products = \DB::connection('mysql2')->table('wp_posts')->where('post_type', 'product')->where('post_status', 'publish')->select('post_title')->get();
        // $productsNames = $products->pluck("post_title");
        
        $fournisseurs = Provider::all();
        $fournisseursSelect = [];
        foreach ($fournisseurs  as $fournisseur) {
            $fournisseursSelect[$fournisseur->id] =
                $fournisseur->name;
        }
      
        return view('admin.stock.edit', compact(
        'stock', 
        'title', 
        'fournisseursSelect',
        //   'productsNames'
        ));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $r, $id) {

        $data = $this->validate(request(),
            [
                'description'     => 'required',
                'provider_id' => 'required',
                'price'    => 'required|numeric',
                'quantity' => 'required|numeric',
                'payment_state' => 'required'

            ], [], [
                'description' => 'description',
                'provider_id' => 'provider_id',
                'price'    => 'price',
                'quantity' => 'quantity',
                'payment_state' => 'payment_state'

            ]);
     
        Stock::where('id', $id)->update($data);
        session()->flash('success', trans(' Enregistrement mis à jour'));
        return redirect(aurl('stock'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        Stock::find($id)->delete();
        session()->flash('success', trans('Enregistrement supprimé'));
        return redirect(aurl('stock'));
    }

    public function multi_delete() {
        if (is_array(request('item'))) {
            Stock::destroy(request('item'));
        } else {
            Stock::find(request('item'))->delete();
        }
        session()->flash('success', trans('Deleted Record'));
        return redirect(aurl('stock'));
    }

}
